/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.config.handler;

import frc.emul.config.data.CfgItemKernel;
import frc.emul.config.handler.CLHShaders;
import frc.emul.config.handler.ConfigLoaderHandler;
import frc.util.xml.XMLLoaderHandler;
import frc.util.xml.XMLLoaderHandlerValue;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

public class CLHShaderKernel
extends ConfigLoaderHandler {
    private CfgItemKernel kernel;
    private XMLLoaderHandler valueHandler;
    private List<Float> values;

    CLHShaderKernel(CLHShaders cLHShaders) {
        super(cLHShaders);
    }

    public void pushed(Attributes attributes) {
        String string = attributes.getValue("id");
        if (string == null) {
            throw new RuntimeException("Empty shader kernel ID");
        }
        this.kernel = ((CLHShaders)this.getParent()).shader.getKernel(string);
        if (this.kernel == null) {
            throw new RuntimeException("Unknown shader kernel ID [" + string + "]");
        }
        this.values = new ArrayList<Float>();
        this.valueHandler = new XMLLoaderHandlerValue(this){

            public void handleValue(String string) {
                try {
                    CLHShaderKernel.this.values.add(Float.valueOf(Float.parseFloat(string)));
                }
                catch (Exception exception) {
                    throw new RuntimeException("Invalid shader kernel's value [" + string + "]");
                }
            }
        };
    }

    public void poped() {
        int n = this.values.size();
        if (n == 0) {
            throw new RuntimeException("The shader kernel's matrix is empty!");
        }
        float[] fArray = new float[n];
        while (n-- > 0) {
            fArray[n] = this.values.get(n).floatValue();
        }
        this.kernel.setHalfMatrix(fArray);
    }

    public XMLLoaderHandler getChildHandler(String string, Attributes attributes) {
        return string.equals("value") ? this.valueHandler : super.getChildHandler(string, attributes);
    }
}

